<?php  
session_start();
include('connection.php');
if(!isset($_SESSION['admin_login']) ){
    ?>
<script>
window.location="login.php";
</script>
<?php
}
$admin_username = $_SESSION['admin_login'];
$_SESSION['user_type'] = 'Teacher';

// List of Tanzanian subjects with their table names
$subjects = [
    'Mathematics' => 'mathematics',
    'English' => 'english',
    'Kiswahili' => 'kiswahili',
    'Physics' => 'physics',
    'Chemistry' => 'chemistry',
    'Biology' => 'biology',
    'Geography' => 'geography',
    'History' => 'history',
    'Civics' => 'civics',
    'French' => 'french',
    'Literature' => 'literature',
    
];

// Initialize a message variable
$message = "";
$message_type = ""; // To store message type: success or danger

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $class = $_POST['class'];
    $exam_type = $_POST['exam_type'];
    $year = $_POST['year'];
    $subject = $_POST['subject'];  // Selected subject
    $score_data = $_POST['score'];  // Scores keyed by registration_number

    // Convert subject to match table names (lowercase)
    $subject_table = strtolower($subject);

    // Check if the selected subject exists in the subject list
    if (in_array($subject_table, $subjects)) {
        $anySubmitted = false;  // Track if any submission occurred
        $anyExisting = false;    // Track if any record already exists

        // Insert scores into the selected subject table
        foreach ($score_data as $registration_number => $score) {
            // Check if the record already exists
            $check_sql = "SELECT * FROM $subject_table 
                          WHERE registration_number = ? 
                          AND class = ? 
                          AND year = ? 
                          AND exam_type = ?";
            $check_stmt = $con->prepare($check_sql);
            $check_stmt->bind_param('ssss', $registration_number, $class, $year, $exam_type);
            $check_stmt->execute();
            $result = $check_stmt->get_result();

            // If record doesn't exist, insert it
            if ($result->num_rows == 0) {
                $sql = "INSERT INTO $subject_table (registration_number, class, year, subject, score, exam_type, uploaded_by) 
                        VALUES (?, ?, ?, ?, ?, ?, ?)";
                $stmt = $con->prepare($sql);
                $stmt->bind_param('ssissss', $registration_number, $class, $year, $subject, $score, $exam_type, $teacher_username);
                $stmt->execute();
                $anySubmitted = true; // Mark that a submission occurred
            } else {
                $anyExisting = true; // Mark that a record already exists
            }
        }

        // Prepare the message based on the submission status
        if ($anySubmitted && $anyExisting) {
            $message = "Results uploaded successfully! Some results were already submitted.";
            $message_type = "success";
        } elseif ($anySubmitted) {
            $message = "Results for $subject uploaded successfully!";
            $message_type = "success";
        } elseif ($anyExisting) {
            $message = " Already submitted!";
            $message_type = "danger";
        } else {
            $message = "No results were uploaded.";
            $message_type = "danger";
        }
    } else {
        // If subject doesn't exist in the list, display an error
        $message = "Invalid subject selected!";
        $message_type = "danger";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload School Results</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding-top: 70px;
        }
        footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            height: 60px;
            background-color: #f8f9fa;
            border-top: 1px solid #dee2e6;
            text-align: center;
            line-height: 60px;
        }
    </style>
</head>
<body>

<!-- Header -->
<nav class="navbar navbar-expand-lg navbar-light bg-light fixed-top">
    <a class="navbar-brand" href="#">Admin Dashboard</a>
    <div class="collapse navbar-collapse">
        <ul class="navbar-nav mr-auto">
            <li class="nav-item active">
                <a class="nav-link" href="#">/ Upload Results</a>
            </li>
        </ul>
        <span class="navbar-text">
            Welcome, <?php echo htmlspecialchars($admin_username); ?>!
        </span>
    </div>
</nav>
<div class="container mt-5">
    <h2>Upload School Results</h2>

    <!-- Display message if available -->
    <?php if ($message): ?>
        <div class='alert alert-<?php echo $message_type; ?>'><?php echo $message; ?></div>
    <?php endif; ?>

    <form method="POST">
        <!-- Class Selection -->
        <div class="form-group">
            <label for="class">Class</label>
            <select name="class" id="class" class="form-control" required>
                <option value="">Select Class</option>
                <option value="Form One">Form One</option>
                <option value="Form Two">Form Two</option>
                <option value="Form Three">Form Three</option>
                <option value="Form Four">Form Four</option>
            </select>
        </div>

        <!-- Exam Type Selection -->
        <div class="form-group">
            <label for="exam_type">Exam Type</label>
            <select name="exam_type" id="exam_type" class="form-control" required>
                <option value="">Select Exam Type</option>
                <option value="Midterm 1 Examination">Midterm 1 Examination</option>
                <option value="Terminal Examination">Terminal Examination</option>
                <option value="Midterm 2 Examination">Midterm 2 Examination</option>
                <option value="Annual Examination">Annual Examination</option>
                <option value="Mock Examination">Mock Examination</option>
                <option value="Pre Necta Examination 1">Pre Necta Examination 1</option>
                <option value="Pre Necta Examination 2">Pre Necta Examination 2</option>
                <option value="Pre Necta Examination 3">Pre Necta Examination 3</option>
                <option value="Pre Necta Examination 4">Pre Necta Examination 4</option>
                <option value="Pre Necta Examination 5">Pre Necta Examination 5</option>
            </select>
        </div>

        <!-- Subject Selection -->
        <div class="form-group">
            <label for="subject">Subject</label>
            <select name="subject" id="subject" class="form-control" required>
                <option value="">Select Subject</option>
                <?php
                foreach ($subjects as $subject_name => $table_name) {
                    echo "<option value='$subject_name'>$subject_name</option>";
                }
                ?>
            </select>
        </div>

        <!-- Year Selection (Generated up to the current year) -->
        <div class="form-group">
            <label for="year">Year</label>
            <select name="year" id="year" class="form-control" required>
                <?php
                $currentYear = date('Y');
                for ($year = 2010; $year <= $currentYear; $year++) {
                    echo "<option value='$year'>$year</option>";
                }
                ?>
            </select>
        </div>

        <!-- Student List and Scores -->
        <div id="student-scores" class="mt-4">
            <!-- This section will be dynamically populated with the student list and score input after class selection -->
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary mt-3">Submit Results</button>
    </form>
</div>
<br><br><br><br>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
    $(document).ready(function () {
        // Load student list dynamically based on class selection
        $('#class').change(function () {
            var selectedClass = $(this).val();
            if (selectedClass) {
                $.ajax({
                    url: 'teacher_dashboard_fetchstudentstopostresults.php',  // A separate PHP file that returns students based on class
                    method: 'POST',
                    data: { class: selectedClass },
                    success: function (response) {
                        $('#student-scores').html(response);
                    }
                });
            } else {
                $('#student-scores').html('');
            }
        });
    });
</script>

<!-- Footer -->
<footer>
    &copy; <?php echo date("Y"); ?> Mwalongo Secondary School. All Rights Reserved.
</footer>

</body>
</html>
